# import asyncio
# from asyncore import loop
# import json
# import fnmatch
# import time as time
# from turtle import end_fill

import inspect
import time
import csv
import math
from datetime import datetime
import socket
import inspect

from fleming.hta.myProps import props
from fleming.hta.myNumPy import *
from fleming.hta.filenameGen import fnameGen
from fleming.hta.call_function_sequence import *

from PyRunner.urpc_enum.measurementparameter import MeasurementParameter
from PyRunner.virtualunits.vu_measurement_unit import VUMeasurementUnit

from PyRunner.meas_services.instrument import InstrumentService
from PyRunner.urpc_enum.measurementparameter import MeasurementParameter
from PyRunner.jrpc_data.instrumentconfiguration import InstrumentConfiguration
from py_pli.pylib import VUnits, Measurements
from PyRunner.predefined_tasks.common.helper import initialize_instrument

import PyRunner.config_enum.detector_aperture_slider_enum as detect_aperture_enum
import PyRunner.config_enum.measurement_unit_enum as meas_unit_enum
import PyRunner.config_enum.scan_table_enum as scan_table_enum
import PyRunner.config_enum.bottom_light_director_enum as bld_enum
import PyRunner.config_enum.filter_module_slider_enum as fms_enum
import PyRunner.config_enum.excitationlight_selector_enum as els_enum


# from PyRunner.meas_services.trf_laser import TRFLaserService

instrument = socket.gethostname()

meas_unit = VUnits.instance.hal.measurementUnit

els = VUnits.instance.hal.excitationLightSelector
fms = VUnits.instance.hal.filterModuleSlider
fm = VUnits.instance.hal.focusMover
scan_table = VUnits.instance.hal.scan_table
st = VUnits.instance.hal.scan_table
das1 = VUnits.instance.hal.detectorApertureSlider1
das2 = VUnits.instance.hal.detectorApertureSlider2
bld = VUnits.instance.hal.bottomLightDirector
pd = VUnits.instance.hal.plateDoor



temperature_sensors=VUnits.instance.hal.temperature_sensors
instrument_service = InstrumentService(hal=VUnits.instance.hal)

# trf_service = TRFLaserService(hal=VUnits.instance.hal)
# fleming.hta.fleming_measurement.testing
async def testing():
    t= detect_aperture_enum
    a= t.Positions.Ap_1_6
    c=das1.get_config(a)
    
    print(a,c)

async def set_all_mover_positions(pos):
    await els.Move(pos['els_pos'])
    await fms.Move(pos['fms_pos'])
    await fm.Move(pos['fm_pos'])
    await scan_table.Move(*pos['st_pos'])
    await das1.Move(pos['das1_pos'])
    await das2.Move(pos['das2_pos'])
    await bld.Move(pos['bld_pos'])
    await pd.Move(pos['pd_pos'])
    return


# # fleming.hta.fleming_measurement.get_all_mover_positions
# async def get_all_mover_positions(mode='props'): # 'props','dict'
#     els_pos = round(await els.GetPosition(), 3)
#     fms_pos = round(await fms.GetPosition(), 3)
#     fm_pos = round(await fm.GetPosition(), 3)
#     st_pos = [round(x,3) for x in list(await scan_table.GetPosition())]
#     das1_pos = round(await das1.GetPosition(), 3)
#     das2_pos = round(await das2.GetPosition(), 3)
#     bld_pos = round(await bld.GetPosition(), 3)
#     pd_pos = round(await pd.GetPosition(), 3)
    
#     re = var2dict(bld_pos,els_pos,fm_pos,fms_pos,st_pos,das1_pos,das2_pos,pd_pos)
#     # print(re)
#     return re

async def get_parameter_list():
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    dl1 = await meas_unit.endpoint.GetParameter(MeasurementParameter.PMT1DiscriminatorLevel)
    for attribute, value in MeasurementParameter.__dict__.items():
        print(attribute,value)
    return


async def myInitialization():
    if not hasattr(myInitialization, "initialized"):
        myInitialization.initialized = False
        # myInitialization.counter=0
    if myInitialization.initialized == False:
        await initialize_instrument()
        print("initilzation done!")
        myInitialization.initialized = True
    # myInitialization.counter+=1
    # print(myInitialization.counter)
    
async def abs_init(filter_ID=1002, meas_height=15, meas_time=100, num_wells=96, top_meas=True):
    await myInitialization()

    await Measurements.instance.abs.test_init(filter_ID, meas_height, meas_time, num_wells, top_meas) #
    await Measurements.instance.abs.preExecute()
    
    await VUnits.instance.hal.excitationLightSelector.SelectPosition("Flash2") # any 
    # await VUnits.instance.hal.filterModuleSlider.SelectModule(0)
    await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId(filter_ID) # fi
    await VUnits.instance.hal.detectorApertureSlider1.MoveTo30Pos() 
    await VUnits.instance.hal.detectorApertureSlider2.MoveTo30Pos() 

async def kaleido_abs(meas_time=0.1): # fm_barcode=1001, meas_height=15, meas_time=0.1, num_wells=96, top_meas=False):
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    meas_unit.ClearOperations()
    op_id = "Testabs"
    
    await meas_unit.LoadFIOperation(op_id, meas_time)
    
    await meas_unit.ExecuteMeasurement(op_id)
    results = await meas_unit.ReadMeasurementValues(op_id)
    return results


async def FI_init(filter_ID=1001, meas_height=15, meas_time=100, num_wells=96, top_meas=True):
    await myInitialization()

    await Measurements.instance.fiMeas.test_init(filter_ID, meas_height, meas_time, num_wells, top_meas) #
    await Measurements.instance.fiMeas.preExecute()
    
    await VUnits.instance.hal.excitationLightSelector.SelectPosition("Flash2") # any 
    # await VUnits.instance.hal.filterModuleSlider.SelectModule(0)
    await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId(filter_ID) # fi
    await VUnits.instance.hal.detectorApertureSlider1.MoveTo30Pos() 
    await VUnits.instance.hal.detectorApertureSlider2.MoveTo30Pos()

async def kaleido_FI(meas_time=0.1): # fm_barcode=1001, meas_height=15, meas_time=0.1, num_wells=96, top_meas=False):
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    meas_unit.ClearOperations()
    op_id = "TestFI"
    
    await meas_unit.LoadFIOperation(op_id, meas_time)
    
    await meas_unit.ExecuteMeasurement(op_id)
    results = await meas_unit.ReadMeasurementValues(op_id)
    re = Measurements.instance.fiMeas.eval_fpga_result(results)

    return props(re)


# fleming.hta.fleming_measurement.lum_init()
async def darkcount_measurement_init():
    await myInitialization()

async def kaleido_darkcount(det_time_ms = 1000):
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    meas_unit.ClearOperations()
    op_id = "darkcount_lum"
    
    await meas_unit.LoadUSLumOperation(op_id, det_time_ms)
    
    await meas_unit.ExecuteMeasurement(op_id)
    results = await meas_unit.ReadMeasurementValues(op_id)
    results = [results[0],results[4]]
    return results




# fleming.hta.fleming_measurement.lum_init()
async def abs_excitation_init(filter_module_id="1006"):
    await myInitialization()

    await Measurements.instance.absfMeas.test_init(filter_module_id, meas_height=10, meas_time_ms=50, no_flashes=False) # measTime_ms = 100, measHeight = 7.5, filterId = 9001, topMeas = True, noOfWells = 96)
    await Measurements.instance.absfMeas.preExecute()
    
    # await VUnits.instance.hal.excitationLightSelector.SelectPosition("TRF") # any 
    # await VUnits.instance.hal.filterModuleSlider.SelectModule(0)
    # await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId("5001") # alpha and lum
    # await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId("3001") # alpha and lum
    # await VUnits.instance.hal.detectorApertureSlider1.MoveTo30Pos() 
    # await VUnits.instance.hal.detectorApertureSlider2.MoveTo30Pos() 

async def kaleido_abs_excitation(det_time_ms = 1000,noFlashes=False):
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    meas_unit.ClearOperations()
    op_id = "abs"
    
    await meas_unit.LoadABSOperation(op_id,det_time_ms, noFlashes)
    
    await meas_unit.ExecuteMeasurement(op_id)
    results = await meas_unit.ReadMeasurementValues(op_id)
    re=Measurements.instance.absfMeas.eval_fpga_result(results)
    
    return props(re) #results.append(re)





# fleming.hta.fleming_measurement.lum_init()
async def abs_init(filter_module_id=1006):
    await myInitialization()

    await Measurements.instance.absfMeas.test_init(filter_module_id, meas_height=10, meas_time_ms=50, no_flashes=False) # measTime_ms = 100, measHeight = 7.5, filterId = 9001, topMeas = True, noOfWells = 96)
    await Measurements.instance.absfMeas.preExecute()
    
    # await VUnits.instance.hal.excitationLightSelector.SelectPosition("TRF") # any 
    # await VUnits.instance.hal.filterModuleSlider.SelectModule(0)
    # await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId("5001") # alpha and lum
    # await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId("3001") # alpha and lum
    # await VUnits.instance.hal.detectorApertureSlider1.MoveTo30Pos() 
    # await VUnits.instance.hal.detectorApertureSlider2.MoveTo30Pos() 

async def kaleido_abs(det_time_ms = 1000,noFlashes=False):
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    meas_unit.ClearOperations()
    op_id = "abs"
    
    await meas_unit.LoadABSOperation(op_id,det_time_ms, noFlashes)
    
    await meas_unit.ExecuteMeasurement(op_id)
    results = await meas_unit.ReadMeasurementValues(op_id)
    re=Measurements.instance.absfMeas.eval_fpga_result(results)
    
    return props(re) #results.append(re)


# fleming.hta.fleming_measurement.lum_init()
async def lum_init(filter_id):
    await myInitialization()

    # await Measurements.instance.lumMeas.test_init(measTime_ms = 1000, measHeight = 8, filterId = 5001) # measTime_ms = 100, measHeight = 7.5, filterId = 9001, topMeas = True, noOfWells = 96)
    # await Measurements.instance.lumMeas.preExecute()
    
    await VUnits.instance.hal.excitationLightSelector.SelectPosition("TRF") # any 
    # await VUnits.instance.hal.filterModuleSlider.SelectModule(0)
    await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId(filter_id) # alpha and lum
    # await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId("5001") # alpha and lum
    # await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId("3001") # alpha and lum
    # await VUnits.instance.hal.detectorApertureSlider1.MoveTo30Pos() 
    # await VUnits.instance.hal.detectorApertureSlider2.MoveTo30Pos() 

async def kaleido_lum(det_time_ms = 1000):
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    meas_unit.ClearOperations()
    op_id = "TestLum"
    
    await meas_unit.LoadUSLumOperation(op_id, det_time_ms)
    
    await meas_unit.ExecuteMeasurement(op_id)
    results = await meas_unit.ReadMeasurementValues(op_id)
    results = [results[0],results[4]]
    return results


async def alpha_init():
    await myInitialization()

    await Measurements.instance.asMeas.test_init(exc_time_ms=100, det_time_ms=50, filter_barcode=1006, plate_height=17.) # exc_time_ms=100, det_time_ms=50, filter_barcode=5001, plate_height=17.0
    await Measurements.instance.asMeas.preExecute()
    
    await VUnits.instance.hal.excitationLightSelector.SelectPosition("Alpha") # any 
    # await VUnits.instance.hal.filterModuleSlider.SelectModule(0)
    await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId("1006") # alpha and lum
    # await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId("3001") # alpha and lum
    await VUnits.instance.hal.detectorApertureSlider1.MoveTo30Pos() 
    await VUnits.instance.hal.detectorApertureSlider2.MoveTo30Pos() 

#alc = 0.38, alphaontime = 180 ms, alphadelay = 15 ms, alphaofftime = 370 ms, mfilter = 1 (position, filter module 5001), focus = 7, pt = 1 (384 plate), pmt1hv=0.5, discr1=0.27, pmt2hv=0.5, discr2=0.27)
async def kaleido_alpha(exc_power=0.38, exc_time_ms = 180, det_time_ms = 370, pause_ms=1, ref_window_ms = 5):
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    meas_unit.ClearOperations()
    op_id = "TestAlpha"
    
    #await meas_unit.TRFLaserInit()
    await meas_unit.LoadAlphaOperation(op_id, exc_time_ms, det_time_ms, pause_ms, ref_window_ms)
    # await meas_unit.LoadTRFOperation(op_id, measurementTime, numberOfWindows, delay_us, windowTime_us, windowPauseTime_us, hiPower=True)
    
    await meas_unit.ExecuteMeasurement(op_id)
    results = await meas_unit.ReadMeasurementValues(op_id)
    return list([results[0], results[2]])+ results


# fleming.hta.fleming_measurement.trf_flashlamp_init()
async def trf_flashlamp_init(filterModule = 4002, measTime = 100, numberOfWindows = 1, delay_us = 100, windowTime_us = 400):
    await myInitialization()
    #meas_height=7, meas_time=100, filter_module=9001, number_of_windows=3, delay_us=5,
    # window_time_us=30, window_pause_time_us=30, num_wells=96, top_meas=True, hi_power=False
    # await Measurements.instance.trfService.test_init(meas_height=7, meas_time=measTime, filter_module=filterModule, number_of_windows=numberOfWindows, delay_us=delay_us, window_time_us=windowTime_us,hi_power=True)
    # await Measurements.instance.trfService.preExecute()
    
    await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId(filterModule)
    # await VUnits.instance.hal.filterModuleSlider.SelectModule(0)
    # await VUnits.instance.hal.filterModuleSlider.SelectModule(0)
    await VUnits.instance.hal.detectorApertureSlider1.MoveTo30Pos() 
    await VUnits.instance.hal.detectorApertureSlider2.MoveTo30Pos() 

async def kaleido_trf_flashlamp(measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0):
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    meas_unit.ClearOperations()
    op_id = "TestFlashLamp"
    numberOfWindows=1
    
    await meas_unit.LoadTRFOperation(op_id, measurementTime, numberOfWindows, delay_us, windowTime_us, windowPauseTime_us, hiPower=True)
    
    await meas_unit.ExecuteMeasurement(op_id)
    results = await meas_unit.ReadMeasurementValues(op_id)
    return list([results[4], results[6]])+ results



# fleming.hta.fleming_measurement.alpha_photo_init()
async def alpha_photo_init(filterModule = 1006, illumination = 0.1, detection = 0.01):
    # await myInitialization()
    # exc_time_ms: int=100, det_time_ms: int=50, filter_barcode=5001, plate_height: float=17.0, num_wells: int=96, photo = False

    photoDiode=True    
    # await Measurements.instance.asMeas.test_init(exc_time_ms=illumination*1000, det_time_ms=detection*1000, filter_barcode=filterModule, plate_height = 17, num_well=96, photo=photoDiode)
    # await Measurements.instance.asMeas.test_init(filter_barcode=filterModule,photo=photoDiode)
    await Measurements.instance.asMeas.test_init(exc_time_ms=100, det_time_ms=50, filter_barcode=1006, plate_height=17.,photo=photoDiode) # exc_time_ms=100, det_time_ms=50, filter_barcode=5001, plate_height=17.0
    await Measurements.instance.asMeas.preExecute()
    
    # await VUnits.instance.hal.excitationLightSelector.SelectPosition("TRF")
    # await VUnits.instance.hal.filterModuleSlider.SelectModule(0)
    await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId(filterModule) # alpha and lum
    await VUnits.instance.hal.detectorApertureSlider1.Home() 
    await VUnits.instance.hal.detectorApertureSlider2.Home() 


# fleming.hta.fleming_measurement.kaleido_alpha_photodiode  
async def kaleido_alpha_photodiode(illumination = 0.01, detection = 0.01):
    #self, exc_time_ms: int=100, det_time_ms: int=50, filter_barcode=5001, plate_height: float=17.0, num_wells: int=96, photo = False
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    meas_unit.ClearOperations()
    op_id = "alpha_photo"
    # await self.hal.measurementUnit.LoadAlphaPhotoOperation(self.op_guid, int(exc_time_ms), int(det_time_ms), pause_ms=10, ref_window_ms=0.5)    
    await meas_unit.LoadAlphaPhotoOperation(op_id, exc_time_ms=int(illumination*1000), det_time_ms=int(detection*1000), pause_ms=0, ref_window_ms=int(illumination*1000))
    # op_id, exc_time_ms, det_time_ms, pause_ms, ref_window_ms
    await meas_unit.ExecuteMeasurement(op_id)
    results = await meas_unit.ReadMeasurementValues(op_id)
    # print(Measurements.instance)
    # re= Measurements.instance.afMeas.eval_fpga_result(results, offset =0)
    # return props(re) # list([results[4], results[6]])+ results
    # return re
    return results


# fleming.hta.fleming_measurement.trf_laser_photo_init()
async def trf_laser_photo_init(filterModule = 1006, measTime = 100, numberOfWindows = 1, delay_us = 100, windowTime_us = 100, photoDiode=True):
    # await myInitialization()
    # await trf_go()
    # await sys_test_trf_init()  
    # await meas_unit.TRFLaserReset()
    # filterModule = 1005
    # filterModule = 4006
    
    measHeight = 8 
    await Measurements.instance.trfLaserMeas.test_init(measHeight, measTime, filterModule, numberOfWindows, delay_us, windowTime_us, windowPauseTime_us=0, noOfWells=96, photo=photoDiode)
    await Measurements.instance.trfLaserMeas.preExecute()
    
    await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId(filterModule)
    
    if True:
        await meas_unit.TRFLaserInit()
        await meas_unit.TRFLaserEnable(True)
        await meas_unit.TRFLedState(False)
        await meas_unit.TRFClearInterlock()
        
        # await VUnits.instance.hal.excitationLightSelector.SelectPosition("TRF")
        # await VUnits.instance.hal.filterModuleSlider.SelectModule(0)
        # await VUnits.instance.hal.detectorApertureSlider1.MoveTo30Pos() 
        # await VUnits.instance.hal.detectorApertureSlider2.MoveTo30Pos() 


# fleming.hta.fleming_measurement.kaleido_trf_laser_photodiode
async def kaleido_trf_laser_photodiode(measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0):
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    meas_unit.ClearOperations()
    op_id = "TestTRF"
    
    await meas_unit.TRFClearInterlock() # might neccesory when things are messed up
    await meas_unit.LoadTRFLaserPhotoOperation(op_id, measurementTime, numberOfWindows, delay_us, windowTime_us, windowPauseTime_us)
    
    await meas_unit.ExecuteMeasurement(op_id)
    print("before measurement")
    results = await meas_unit.ReadMeasurementValues(op_id)
    re= Measurements.instance.trfLaserMeas.eval_fpga_result(results, offset =0)
    return props(re) # list([results[4], results[6]])+ results
    # return results


# fleming.hta.fleming_measurement.trf_laser_init()
async def trf_laser_init(measHeight = 8, measTime = 100, filterModule = 4001, numberOfWindows = 1, delay_us = 100, windowTime_us = 100, photoDiode=False):
    # await myInitialization()
    # await trf_go()
    # await sys_test_trf_init()  
    # await meas_unit.TRFLaserReset()
    await Measurements.instance.trfLaserMeas.test_init(measHeight, measTime, filterModule, numberOfWindows, delay_us, windowTime_us, windowPauseTime_us=0, noOfWells=96, photo=photoDiode)

    if True:
        await meas_unit.TRFLaserInit()
        await meas_unit.TRFLaserEnable(True)
        await meas_unit.TRFLedState(False)
        await meas_unit.TRFClearInterlock()
        
        await VUnits.instance.hal.excitationLightSelector.SelectPosition("TRF")
        # await VUnits.instance.hal.filterModuleSlider.SelectModule(0)
        await VUnits.instance.hal.detectorApertureSlider1.MoveTo30Pos() 
        await VUnits.instance.hal.detectorApertureSlider2.MoveTo30Pos() 

# fleming.hta.fleming_measurement.kaleido_trf_laser
async def kaleido_trf_laser(measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0):
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    meas_unit.ClearOperations()
    op_id = "TestTRF"
    
    await meas_unit.TRFClearInterlock() # might neccesory when things are messed up

    await meas_unit.LoadTRFLaserOperation(op_id, measurementTime, numberOfWindows, delay_us, windowTime_us, windowPauseTime_us)
    
    await meas_unit.ExecuteMeasurement(op_id)
    results = await meas_unit.ReadMeasurementValues(op_id)
    re= Measurements.instance.trfLaserMeas.eval_fpga_result(results, offset =0)
    return props(re) # re # list([results[4], results[6]])+ results

async def focusMove(v): # kaleido height
    await VUnits.instance.hal.focusMover.GotoFocusHeight(v)
    # GetFocusHeightPos
           
async def readBCR():
    res=await instrument_service.ScanFilterModules()
    print(res)
    return    


async def scanTable_init(platetype="'384 OptiPlate (White)'"):
    if not hasattr(scanTable_init, "initialized"):
        scanTable_init.initialized = False
    if scanTable_init.initialized == False:
        scan_table = VUnits.instance.hal.scan_table
        scan_table.SetPlateType(platetype) # follow the function, there is a list of accepted names
        await scan_table.Home()
        scan_table.SetCurrentMeasPosition(scan_table_enum.GC_Params.FBDTop_TopLeftCorner)
        scan_table.get_config(scan_table_enum.GC_Params.FBDTop_TopLeftCorner)
        scanTable_init.initialized = True

    # return rows,cols
async def openPlateDoor():
    pd=VUnits.instance.hal.plateDoor
    await pd.Open()

async def closePlateDoor():
    pd=VUnits.instance.hal.plateDoor
    await pd.Close()


# async scanPlate(*args)
# plate scanning position initilizationa and scan
# await scanTable_init()
# await scanPlate([1,2],[3,4]) # row=[1,2],column=[3,4]):  initilizing the well scaning square
# await [col,row]=scanPlate() # move to the next position,Check the scanning position
# await [col,row]=scanPlate('current') # do nothing but return the poisition on the plate
async def scanPlate(*args): # row=[1,2],column=[3,4]):    
    st = VUnits.instance.hal.scan_table
    if len(args)>1:
        await scanTable_init()
        scanPlate.row=args[0]
        if (scanPlate.row[0]<1) | (scanPlate.row[1]<scanPlate.row[0]):
            print("scan plate row < 0 or higher boundary is smaller than the small one")
            return 1
        scanPlate.column=args[1]
        if (scanPlate.column[0]<1) | (scanPlate.column[1]<scanPlate.column[0]):
            print("scan plate column < 0 or higher boundary is smaller than the small one")
            return 1
        scanPlate.crow=scanPlate.row[0]
        scanPlate.ccolumn=scanPlate.column[0]-1
        return
    elif len(args)==0:
        if scanPlate.ccolumn < scanPlate.column[1]:
            # move table
            scanPlate.ccolumn+=1
            await st.MoveToWell(scanPlate.ccolumn,scanPlate.crow)
            
        elif scanPlate.ccolumn == scanPlate.column[1]:
            # move table  
            if scanPlate.crow >= scanPlate.row[1]:
                return [-1]
            scanPlate.ccolumn = scanPlate.column[0]
            scanPlate.crow+=1
            await st.MoveToWell(scanPlate.ccolumn,scanPlate.crow)
            print(scanPlate.crow, scanPlate.ccolumn)
            return [scanPlate.ccolumn, scanPlate.crow]
    else:
        if args[0]=="current":
            return [scanPlate.ccolumn,scanPlate.crow]

# await scanWell([1.5,9],[1.5,9]): 0.45X8=3.6mm. row, column, [1.5(scan range,mm), 9 (9 points)]
# example:
#  await scanWell([1.5,9],[1.5,9]) # initialization.
# for i in range(36):
    # await scanWell()
async def scanWell(*args):
    st = VUnits.instance.hal.scan_table
    if len(args)>1:
        if (args[0][0]<0) | (args[0][1]<1):
            print("well scan row direction (y): range and steps!")
            return
        if (args[1][0]<0) | (args[1][1]<=1):
            print("well scan column direction (x): range and steps!")
            return
        # set current position
        try:
            x0,y0=st.get_current_position() # get it from saved position.
        #x0,y0=st.GetPosition() # get the updated info from firmware
        except:
            print("State initilization error or stage error!")
        
        scanWell.row= [y0 + a for a in linspace(-args[0][0]/2,args[0][0]/2,args[0][1])]
        scanWell.column= [x0 + a for a in linspace(-args[1][0]/2,args[1][0]/2,args[1][1])]
        scanWell.crow=int(0)
        scanWell.ccolumn=int(-1)
        # print(scanWell.row,scanWell.column)
        return 
    else:
        try:
            if scanWell.ccolumn < len(scanWell.column)-1:
                scanWell.ccolumn+=1
                await st.Move(scanWell.column[scanWell.ccolumn],scanWell.row[scanWell.crow])
                
            elif scanWell.ccolumn == len(scanWell.column)-1:
                # move table  
                if scanWell.crow >= len(scanWell.row):
                    return [-1]
                scanWell.ccolumn = 0
                scanWell.crow+=1
                await st.Move(scanWell.column[scanWell.ccolumn],scanWell.row[scanWell.crow])
        except:
            print("scanWell intilization missing!") 
                
    # print(scanWell.ccolumn, scanWell.crow, scanWell.column[scanWell.ccolumn],scanWell.row[scanWell.crow])
    return [scanWell.ccolumn,scanWell.crow]


async def coolingControl(t=25.0):
    c1= await pmt1_target_temp(t)
    c2 =await pmt2_target_temp(t)
    # await cooling(0,0)
    # time.sleep(0.2)
    # await cooling(1,1)
    # time.sleep(0.2)
    return [c1,c2]
    
# example:     
# print(await get_parameter("PMT1HighVoltageSetting"))
async def get_parameter(name):
    # name="PMT1HighVoltageSetting"
    return await meas_unit.endpoint.GetParameter(getattr(MeasurementParameter,name))
    
async def set_parameter(name,v):
    await meas_unit.endpoint.SetParameter(getattr(MeasurementParameter,name), v)
    
## low level function from Teemu, not intent to use it anymore.
async def background_test(dt=0.1):  
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    #op_id="background_test"
    op_id=inspect.stack()[0][3]
    await meas_unit.LoadPMTTest(op_id,int(dt*1e3)) # ms
    await meas_unit.ExecuteMeasurement(op_id)
    return await meas_unit.ReadMeasurementValues(op_id)

async def pmt_exposure(dt):  
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    #op_id="background_test"
    op_id=inspect.stack()[0][3]
    await meas_unit.LoadPMTTest(op_id,int(dt*1e3)) # ms
    await meas_unit.ExecuteMeasurement(op_id)
    return await meas_unit.ReadMeasurementValues(op_id)
     
async def apertures(aper1,aper2): # -1:1.6; 0: close; 1:3
    as1 = VUnits.instance.hal.detectorApertureSlider1
    as2 = VUnits.instance.hal.detectorApertureSlider2
    if aper1 == 0:
        await as1.Home()
        #print("aperture 1 closed")
    elif aper1 == -1:
        await as1.MoveTo16Pos()
        #print("aperture 1: 16")
    elif aper1 ==  1:
        await as1.MoveTo30Pos()
        # return "aperture 1: 30"
    else:
        print("wrong position for Aerture 1!\n") 
    
    if aper2 == 0:
        await as2.Home()
        #print("aperture 2 closed")
    elif aper2 == -1:
        await as2.MoveTo16Pos()
        #print("aperture 2: 16")
    elif aper2 ==  1:
        await as2.MoveTo30Pos()
        #return "aperture 2: 30"
    else:
        print("wrong position for Aerture 2!\n") 
    
async def cooling(ch1_enable=True,ch2_enable=True):
    # py_pli.pylib.VUnits.instance.hal.airVentilation_Cooling.disable()
    await VUnits.instance.hal.pmt_ch1_Cooling.enable(ch1_enable)
    await VUnits.instance.hal.pmt_ch2_Cooling.enable(ch2_enable)
    
async def get_dl():
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    dl1 = await meas_unit.endpoint.GetParameter(MeasurementParameter.PMT1DiscriminatorLevel)
    dl2 = await meas_unit.endpoint.GetParameter(MeasurementParameter.PMT2DiscriminatorLevel)
    return list(dl1+dl2)

async def get_hv():
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    hv1 = await meas_unit.endpoint.GetParameter(MeasurementParameter.PMT1HighVoltageSetting)
    hv2 = await meas_unit.endpoint.GetParameter(MeasurementParameter.PMT2HighVoltageSetting)
    return list(hv1+hv2)

async def set_hv(v1,v2):
    if (v1>0.71) | (v2>0.71):
        raise Exception('pmt hv setting exceed the limit and might damage the pmt!')

    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    hv1 = await meas_unit.endpoint.SetParameter(MeasurementParameter.PMT1HighVoltageSetting,v1)
    hv2 = await meas_unit.endpoint.SetParameter(MeasurementParameter.PMT2HighVoltageSetting,v2)
    return

async def set_dl(v1,v2):
    if (v1>0.4) | (v2>0.4) | (v1<0.2) | (v2<0.2):
        raise Exception('pmt dl setting exceed the limit and might damage the pmt!')

    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    hv1 = await meas_unit.endpoint.SetParameter(MeasurementParameter.PMT1DiscriminatorLevel,v1)
    hv2 = await meas_unit.endpoint.SetParameter(MeasurementParameter.PMT2DiscriminatorLevel,v2)
    return

# async def background_batch_linearity_hv():
#     dt = [1., 0.1]
#     time = [10, 10]
#     fname=fnameGen(f"{instrument}_darkcount_linearity_hv",False) 



# async def header_Gen(funcs=[],flagRunCode=True):
#     head=f""
#     for d in funcs:
#         if flagRunCode:
#             out=await d[0](*d[1:len(d)])
#         else:
#             out=None
#         head+=f"{d[0].__name__}; "
#         if len(d)>1:
#             head+="  ".join([f"{x}" for x in d[1:]])
        
#         head+="; "
            
#         if out is None:
#             head+=";"
#             continue
#         else:
#             head+="  ".join([f"{x}" for x in out])
#             head+=";"
            
#     print(head)
#     return head

# # fleming.hta.fleming_measurement.header_output_Gen
# # async def header_output_Gen(funcs=[[kaleido_lum,100],[pmt_exposure,1]],header=False):
# async def header_output_Gen(funcs=[],header=False):
#     head=f""  # string of the function names and out_0, ...
#     info=f""  # string of the function names and the arguments, ...
#     output=[]


#     for d in funcs:
#         out=await d[0](*d[1:len(d)])
#         if out is None:
#             continue

#         if header:
#             if type(out) is dict:
#                 # key=[k for k in out.keys()]
#                 head+="\t".join([f"{x}" for x in out.keys()])
#             else:            
#                 head+=f"{d[0].__name__}_"
#                 head+="\t".join([f"out_{x}" for x in range(0,len(out))])
#                 head+="\t"
            
#             info+=f"{d[0].__name__}; "
#             if len(d)>1:
#                 info+="  ".join([f"{x}" for x in d[1:]])
#             info+="; "

#         if not (out is None):
#             if not(type(out) is dict):
#                 output+=out
#             else:
#                 out=[k for k in out.values()]
#                 output += out

#     print(head,info)
#     if header:
#         return output, head, info
#     else:
#         return output
    

async def pmt1_target_temp(temperature_C = 25.0):
    pmt_cooling = VUnits.instance.hal.pmt_ch1_Cooling
    # await pmt_cooling.InitializeDevice()
    await pmt_cooling.set_target_temperature(temperature_C)
    await pmt_cooling.enable()
    # read the temperature again
    c = await pmt_cooling.get_parameter_value()
    return c

async def pmt2_target_temp(temperature_C = 25.0):
    pmt_cooling = VUnits.instance.hal.pmt_ch2_Cooling
    # await pmt_cooling.InitializeDevice()
    await pmt_cooling.set_target_temperature(temperature_C)
    await pmt_cooling.enable()
    # read the temperature again
    c = await pmt_cooling.get_parameter_value() 
    return c


async def pmt1_temperature():
    return await VUnits.instance.hal.pmt_ch1_Cooling.get_feedback_value()

async def pmt2_temperature():
    return await VUnits.instance.hal.pmt_ch2_Cooling.get_feedback_value()


async def get_all_temp():
    v= temperature_sensors.get_all_temperature_values()
    pmt1 = VUnits.instance.hal.pmt_ch1_Cooling
    pmt2 = VUnits.instance.hal.pmt_ch2_Cooling
    v['pmt1_temp']=await pmt1.get_feedback_value()
    v['pmt2_temp']=await pmt2.get_feedback_value()
    v['pmt1_workload'] = await pmt1.get_output_value()
    v['pmt2_workload'] = await pmt2.get_output_value()
    return v


# fleming.hta.fleming_measurement.test
async def test():
    # await myInitialization()
    await fms.Move(55.5)
    await meas_unit.TRFLaserInit()
    print('init')
    await meas_unit.TRFLaserEnable(True)
    print('enabled')
    await meas_unit.TRFLedState(False)
    await meas_unit.TRFClearInterlock()
    print('interlock')
    # await 
    # print(await peltier_workload())
    # print(await pmt_cooling_feedback())
    for i in range(100):
        re=await kaleido_trf_laser_photodiode(measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0)
        print(re)

# fleming.hta.fleming_measurement.reload
def reload():
    pass

